<?php
date_default_timezone_set('Asia/Jakarta');
require 'whatsapp_bot/config.php';
//header("Content-Type: application/json");
/**
* all data POST sent from  https://texas.wablas.com
* you must create URL what can receive POST data
* we will sent data like this:

* id = message ID - string
* phone = sender phone - string
* message = content of message - string
* pushName = Sender Name like contact name - string (optional)
* groupSubject = Group Name - string (optional)
* timestamp = time send message
* file = name of the file when receiving media message (optional)
* url = url file media message (optional)
* messageType = text/image/document/video/audio/location - string
* mimeType = type file (optional)
* deviceId = unix ID device
* sender = phone number device - integer
*/
$content = json_decode(file_get_contents('php://input'), true);

$id = $content['id'];
$pushName = $content['pushName'];
$isGroup = $content['isGroup'];
if ($isGroup == true) {
    $subjectGroup = $content['group']['subject'];
    $ownerGroup = $content['group']['owner'];
    $decriptionGroup = $content['group']['desc'];
    $partisipanGroup = $content['group']['participants'];
}
$message = $content['message'];
$phone = $content['phone'];
$messageType = $content['messageType'];
$file = $content['file'];
$mimeType = $content['mimeType'];
$deviceId = $content['deviceId'];
$sender = $content['sender'];
$timestamp = $content['timestamp'];

$cek_users = mysqli_query($con, "SELECT * FROM users WHERE phone = '$phone'");
$datanya = mysqli_fetch_assoc($cek_users);

function PostList($payload) {
global $token;
$curl = curl_init();
curl_setopt($curl, CURLOPT_HTTPHEADER,
    array(
        "Authorization: $token",
        "Content-Type: application/json"
    )
);
curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($payload) );
curl_setopt($curl, CURLOPT_URL,  "https://texas.wablas.com/api/v2/send-list");
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

$result = curl_exec($curl);
curl_close($curl);
}

function PostDoc($data) {
global $token;
$curl = curl_init();
curl_setopt($curl, CURLOPT_HTTPHEADER,
    array(
        "Authorization: $token",
    )
);
curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($curl, CURLOPT_URL,  "https://texas.wablas.com/api/send-document");
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

$result = curl_exec($curl);
curl_close($curl);
}

function PostAdmin($pesan) {
  global $token;
  global $admin_phone;
  $result = file_get_contents("https://texas.wablas.com/api/send-message?phone=$admin_phone&message=$pesan&token=$token");
  return $result;
}

function PostText($pesan) {
  global $token;
  global $phone;
  $result = file_get_contents("https://texas.wablas.com/api/send-message?phone=$phone&message=$pesan&token=$token");
  return $result;
}

function PostImg($data) {
  global $token;
  $curl = curl_init();
  curl_setopt($curl, CURLOPT_HTTPHEADER,
    array(
        "Authorization: $token",
    )
);
  curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
  curl_setopt($curl, CURLOPT_URL,  "https://texas.wablas.com/api/send-image");
  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
  
  $result = curl_exec($curl);
  curl_close($curl);
  return $result;
}

function CekUsers($upt = null) {
  global $con;
  global $phone;
  global $pushName;
  global $messageType;
  global $deviceId;
  global $sender;
  global $timestamp;
  
  $cek = mysqli_query($con, "SELECT * FROM users WHERE phone = '$phone'");
  
  if(mysqli_num_rows($cek) > 0) {
    $act = (is_null($upt)) ? mysqli_query($con, "UPDATE users SET action = '' WHERE phone = '$phone'") : mysqli_query($con, "UPDATE users SET action = '$upt' WHERE phone = '$phone'");;
  } else {
    $act = mysqli_query($con, "INSERT INTO users VALUES ('','$phone','$pushName','$messageType','$deviceId','$sender','$timestamp','')");
  }
  
  return $act;
}

function base64_to_jpeg($base64_string, $output_file) {
    // open the output file for writing
    $ifp = fopen( $output_file, 'wb' ); 

    // split the string on commas
    // $data[ 0 ] == "data:image/png;base64"
    // $data[ 1 ] == <actual base64 string>
    $data = explode( ',', $base64_string );

    // we could add validation here with ensuring count( $data ) > 1
    fwrite( $ifp, base64_decode( $data[ 1 ] ) );

    // clean up the file resource
    fclose( $ifp ); 

    return $output_file; 
}

function generateRandomNumber($length = 10) {
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function text_to_img($type,$rand='',$filename,$data='') {
  if($type == '1') {
    $imagetobewatermark=imagecreatefrompng("whatsapp_bot/upload/bahan.png");
    $watermarktext=$rand;
    $font="whatsapp_bot/font/OpenSans-Bold.ttf";
    $fontsize="180";
    $white = imagecolorallocate($imagetobewatermark, 0, 0, 0);
    imagettftext($imagetobewatermark, $fontsize, 0, 210, 730, $white, $font, $watermarktext);
    //header("Content-type:image/png");
    imagepng($imagetobewatermark, 'whatsapp_bot/upload/'.$filename.'.png');
    imagedestroy($imagetobewatermark);
  } elseif($type == '2') {
    $imagetobewatermark=imagecreatefrompng("whatsapp_bot/upload/".$filename.'.png');
    $watermarktext=$data;
    $font="whatsapp_bot/font/OpenSans-Bold.ttf";
    $fontsize="25";
    $white = imagecolorallocate($imagetobewatermark, 0, 0, 0);
    imagettftext($imagetobewatermark, $fontsize, 0, 355, 1022, $white, $font, $watermarktext);
    header("Content-type:image/png");
    imagepng($imagetobewatermark, 'whatsapp_bot/upload/'.$filename.'.png');
    imagedestroy($imagetobewatermark);
  } elseif($type == '3') {
    $imagetobewatermark=imagecreatefrompng("whatsapp_bot/upload/".$filename.'.png');
    $watermarktext=$data;
    $font="whatsapp_bot/font/OpenSans-Bold.ttf";
    $fontsize="25";
    $white = imagecolorallocate($imagetobewatermark, 0, 0, 0);
    imagettftext($imagetobewatermark, $fontsize, 0, 355, 1122, $white, $font, $watermarktext);
    header("Content-type:image/png");
    imagepng($imagetobewatermark, 'whatsapp_bot/upload/'.$filename.'.png');
    imagedestroy($imagetobewatermark);
  } elseif($type == '4') {
    $imagetobewatermark=imagecreatefrompng("whatsapp_bot/upload/".$filename.".png");
    $watermarktext=hari() . ', ' . tgl(date('Y-m-d'));
    $font="whatsapp_bot/font/OpenSans-Regular.ttf";
    $fontsize="20";
    $white = imagecolorallocate($imagetobewatermark, 0, 0, 0);
    imagettftext($imagetobewatermark, $fontsize, 0, 70, 460, $white, $font, $watermarktext);
    header("Content-type:image/png");
    imagepng($imagetobewatermark, 'whatsapp_bot/upload/'.$filename.'.png');
    imagedestroy($imagetobewatermark);
   } elseif($type == '5') {
      $imagetobewatermark=imagecreatefrompng("whatsapp_bot/upload/".$filename.".png");
      $watermarktext=date('H:i:s');
      $font="whatsapp_bot/font/OpenSans-Regular.ttf";
      $fontsize="20";
      $white = imagecolorallocate($imagetobewatermark, 0, 0, 0);
      imagettftext($imagetobewatermark, $fontsize, 0, 850, 460, $white, $font, $watermarktext);
      header("Content-type:image/png");
      imagepng($imagetobewatermark, 'whatsapp_bot/upload/'.$filename.'.png');
      imagedestroy($imagetobewatermark);
   }
  
  return $filename;
}

function hari() {
  $tanggal = date('Y-m-d');
  $day = date('D', strtotime($tanggal));
  $dayList = array(
      'Sun' => 'Minggu',
      'Mon' => 'Senin',
      'Tue' => 'Selasa',
      'Wed' => 'Rabu',
      'Thu' => 'Kamis',
      'Fri' => 'Jumat',
      'Sat' => 'Sabtu'
  );
  return $dayList[$day];
}

function tgl($tanggal){
        $bulan = array (
        1 =>   'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
        );
        
        $pecahkan = explode('-', $tanggal);
        
        // variabel pecahkan 0 = tanggal
        // variabel pecahkan 1 = bulan
        // variabel pecahkan 2 = tahun
         
        return $pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0];
    }
    
function get_nomor() {
  global $con;
  $get = mysqli_query($con, "SELECT * FROM nomor_antrian");
$cokot = mysqli_fetch_assoc($get);

if($cokot['is_antri'] == '1') {
  return false;
} else {
  mysqli_query($con, "UPDATE nomor_antrian SET is_antri = '1'");
  if($cokot['prefix'] == 'A') {
    mysqli_query($con, "UPDATE nomor_antrian SET prefix = 'B', nomor = nomor+1, is_antri = '0'");
    return "A".sprintf('%03d', $cokot['nomor']);
  }
  
  if($cokot['prefix'] == 'B') {
    mysqli_query($con, "UPDATE nomor_antrian SET prefix = 'A', nomor = nomor+1, is_antri = '0'");
    return "B".sprintf('%03d', $cokot['nomor']);
  }
}
}
//print_r($content);
$form = ['1. Form pengajuan','2. Keterangan kejandaan','3. Keterangan Anak Tidak/Belum Menikah atau Bekerja','4. Keterangan Ahli Waris','5. Keterangan Kuasa Ahli Waris','6. Pernyataan Juru Bayar','7. Form SPTB (Surat Pernyataan Tanda Bukti Diri)','8. Form SP3R (Surat Pernyataan Pembayaran Pensiun melalui Rekening)','9. Form Laporan Medis Rawat Inap','10. Surat Kuasa Pengambilan Gaji','11. Surat Pernyataan','12. SPPI/SPPS'];

if(in_array(str_replace(['Formulir pelayanan <~ ','#'], '', $message), $form)) {
  CekUsers('start#formulir_pelayanan#'.str_replace(['Formulir pelayanan <~ ','#'], '', $message));
  $get_txt = str_replace('Formulir pelayanan <~ ', '', $message);
  $exp = explode(".", $get_txt);
  $get_txt = strtolower(trim(end($exp)));
  $get_txt = str_replace([' ','/'], '-', str_replace(['#','(',')'], '', $get_txt));
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/'.$get_txt.'.pdf',
      'secret' => true
  ];
PostDoc($data);
} elseif($message == 'Pilih Persyaratan <~ 1. Pensiun Pertama#') {
  CekUsers('start#persyaratan#pensiun_pertama');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_pertama/PERSYARATAN-PENSIUN-PERTAMA.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_pertama/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_pertama/riwayat-hidup.pdf',
      'secret' => true
  ];
  PostDoc($data2);
} elseif($message == 'Pilih Persyaratan <~ 2. Meninggal Dunia Aktif#') {
  CekUsers('start#persyaratan#meninggal_dunia_aktif');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/meninggal_dunia_aktif/PERSYARATAN-PESERTA-MENINGGAL-DUNIA-AKTIF.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/meninggal_dunia_aktif/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/meninggal_dunia_aktif/riwayat-hidup.pdf',
      'secret' => true
  ];
  PostDoc($data2);
  sleep(2);
  $data3 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/meninggal_dunia_aktif/SKET-KUASA-AHLI-WARIS.pdf',
      'secret' => true
  ];
  PostDoc($data3);
  sleep(2);
  $data4 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/meninggal_dunia_aktif/SURAT-KETERANGAN-AHLI-WARIS.pdf',
      'secret' => true
  ];
  PostDoc($data4);
} elseif($message == 'Pilih Persyaratan <~ 3. Pensiun Wari#') {
  CekUsers('start#persyaratan#pensiun_wari');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_wari/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_wari/KETERANGAN-KEJANDAAN.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/pensiun_wari/PERSYARATAN-PENSIUN-WARI-JANDA-DUDA-DARI-PESERTA-PENSIUN-MENINGGAL-DUNIA.pdf',
      'secret' => true
  ];
  PostDoc($data2);
} elseif($message == 'Pilih Persyaratan <~ 4. SBPP#') {
  CekUsers('start#persyaratan#sbpp');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpp/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpp/PERNYATAAN-JURU-BAYAR.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpp/PERSYARATAN-PESERTA-PENSIUN-MENINGGAL-DUNIA.pdf',
      'secret' => true
  ];
  PostDoc($data2);
  $data3 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpp/SURAT-KETERANGAN-AHLI-WARIS.pdf',
      'secret' => true
  ];
  PostDoc($data3);
} elseif($message == 'Pilih Persyaratan <~ 5. SBPI#') {
  CekUsers('start#persyaratan#sbpi');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpi/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpi/PERNYATAAN-JURU-BAYAR.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpi/PERSYARATAN-PENSIUN-WARI-MENINGGAL-DUNIA.pdf',
      'secret' => true
  ];
  PostDoc($data2);
  sleep(2);
  $data3 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sbpi/SKET-KUASA-AHLI-WARIS.pdf',
      'secret' => true
  ];
  PostDoc($data3);
} elseif($message == 'Pilih Persyaratan <~ 6. UKP#') {
  CekUsers('start#persyaratan#ukp');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/ukp/FORM-SPTB.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/ukp/FORMULIR-PENGAJUAN-UKP-AKIBAT-AUTENTIKASI.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/ukp/PERSYARATAN-UKP.pdf',
      'secret' => true
  ];
  PostDoc($data2);
} elseif($message == 'Pilih Persyaratan <~ 7. SPPI#') {
  CekUsers('start#persyaratan#sppi');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sppi/PERSYARATAN-USUL-SURAT-PERSETUJUAN-PENUNJUKKAN-ISTRI-KHUSUS-TNI-AD.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/sppi/surat-permohonan.pdf',
      'secret' => true
  ];
  PostDoc($data1);
} elseif($message == 'Pilih Persyaratan <~ 8. Tinjau Skep Pensiun#') {
  CekUsers('start#persyaratan#tinjau_skep_pensiun');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/tinjau_skep_pensiun/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/tinjau_skep_pensiun/KETERANGAN-KEJANDAAN.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/tinjau_skep_pensiun/PERSYARATAN-RALAT-SKEP-PENSIUN-DARI-PESERTA-PENSIUN-MENINGGAL-DUNIA-USUL-SKEP-JANDA-DUDA.pdf',
      'secret' => true
  ];
  PostDoc($data2);
} elseif($message == 'Pilih Persyaratan <~ 9. Usul Penerbitan Skep Petikan Ke-2#') {
  CekUsers('start#persyaratan#usul_penerbitan_skep_petikan_ke_2');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/usul_penerbitan_skep_petikan_ke_2/form-pengajuan.pdf',
      'secret' => true
  ];
  PostDoc($data);
  sleep(2);
  $data1 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/usul_penerbitan_skep_petikan_ke_2/KETERANGAN-KEJANDAAN.pdf',
      'secret' => true
  ];
  PostDoc($data1);
  sleep(2);
  $data2 = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/persyaratan/usul_penerbitan_skep_petikan_ke_2/PERSYARATAN-RALAT-SKEP-PENSIUN-DARI-PESERTA-PENSIUN-MENINGGAL-DUNIA-USUL-SKEP-JANDA-DUDA.pdf',
      'secret' => true
  ];
  PostDoc($data2);
} elseif($message == 'ASABRI MOBILE <~ 1. Petunjuk Penggunaan#') {
  CekUsers('start#asabri_mobile#petunjuk_penggunaan');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/asabri_mobile.pdf',
      'secret' => true
  ];
PostDoc($data);
} elseif($message == 'ASABRI MOBILE <~ 2. Link Download#') {
  echo "Silahkan klik link di bawah ini\n\nhttps://play.google.com/store/apps/details?id=com.asabri.layol";
} elseif($message == 'ASABRI STAR <~ 1. Petunjuk Penggunaan#') {
  CekUsers('start#asabri_star#petunjuk_penggunaan');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/asabri_star.pdf',
      'secret' => true
  ];
PostDoc($data);
} elseif($message == 'ASABRI STAR <~ 2. Link Download#') {
  echo "Silahkan klik link di bawah ini\n\nhttps://play.google.com/store/apps/details?id=com.asabri.client";
} else {
if($message == "\xE2\xA4\xB5 <~ 1. Formulir Pelayanan#") {
 CekUsers('start#formulir_pelayanan');
$payload = [
    "data" => [
        [
            'phone' => $phone,
            'message'=> [
                'title' => "Formulir pelayanan",
                'description' => 'Silahkan pilih formulir pelayanan',
                'buttonText' => 'select',
                'secret' => true,
                'lists' => [
                    [
                        'title' => $form[0],
                        //'description' => 'Form pengajuan',
                    ],
                    [
                        'title' => $form[1],
                        //'description' => 'Keterangan kejandaan',
                    ],
                     [
                        'title' => $form[2],
                        //'description' => 'Keterangan Anak Tidak/Belum Menikah atau Bekerja',
                    ],
                    [
                        'title' => $form[3],
                        //'description' => 'Keterangan Ahli Waris',
                    ],
                     [
                        'title' => $form[4],
                       // 'description' => 'Keterangan Kuasa Ahli Waris',
                    ],
                    [
                        'title' => $form[5],
                        //'description' => 'Pernyataan Juru Bayar',
                    ],
                    [
                        'title' => $form[6],
                        //'description' => 'Form SPTB (Surat Pernyataan Tanda Bukti Diri)',
                    ],
                    [
                        'title' => $form[7],
                        //'description' => 'Form SP3R (Surat Pernyataan Pembayaran Pensiun melalui Rekening)',
                    ],
                    [
                        'title' => $form[8],
                        //'description' => 'Form Laporan Medis Rawat Inap',
                    ],
                    [
                        'title' => $form[9],
                        //'description' => 'Surat Kuasa Pengambilan Gaji',
                    ],
                    [
                        'title' => $form[10],
                        //'description' => 'Surat Pernyataan',
                    ],
                    [
                        'title' => $form[11],
                    ],
                ],
                //'footer' => 'footer template here',
            ],
        ]
    ]
];
PostList($payload);
} elseif($message == "\xE2\xA4\xB5 <~ 2. Formulir Pajak#") {
  CekUsers('start#formulir_pajak');
  echo "Silahkan klik link di bawah ini\n\nhttps://www.asabri.co.id/page/40/Formulir_Pajak";
} elseif($message == "\xE2\xA4\xB5 <~ 3. Persyaratan#") {
  CekUsers('start#persyaratan');
  $payload = [
    "data" => [
        [
            'phone' => $phone,
            'message'=> [
                'title' => "Pilih Persyaratan",
                'description' => 'Silahkan pilih layanan persyaratan',
                'buttonText' => 'select',
                'secret' => true,
                'lists' => [
                    [
                        'title' => '1. Pensiun Pertama',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '2. Meninggal Dunia Aktif',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '3. Pensiun Wari',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '4. SBPP',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '5. SBPI',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '6. UKP',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '7. SPPI',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '8. Tinjau Skep Pensiun',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '9. Usul Penerbitan Skep Petikan Ke-2',
                        //'description' => 'Formulir gratis',
                    ],
                ],
                //'footer' => 'Pilih layanan',
            ],
        ]
    ]
];
PostList($payload);
} elseif($message == "\xE2\xA4\xB5 <~ 4. ASABRI MOBILE#") {
  CekUsers('start#asabri_mobile');
  $payload = [
    "data" => [
        [
            'phone' => $phone,
            'message'=> [
                'title' => "ASABRI MOBILE",
                'description' => "Silahkan pilih",
                'buttonText' => 'select',
                'secret' => true,
                'lists' => [
                    [
                        'title' => '1. Petunjuk Penggunaan',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '2. Link Download',
                        //'description' => 'Formulir gratis',
                    ],
                ],
                //'footer' => 'Pilih layanan',
            ],
        ]
    ]
];
PostList($payload);
} elseif($message == "\xE2\xA4\xB5 <~ 5. ASABRI LINK#") {
  CekUsers('start#asabri_link');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/asabri_link.pdf',
      'secret' => true
  ];
PostDoc($data);
} elseif($message == "\xE2\xA4\xB5 <~ 6. ASABRI STAR#") {
  CekUsers('start#asabri_star');
  $payload = [
    "data" => [
        [
            'phone' => $phone,
            'message'=> [
                'title' => "ASABRI STAR",
                'description' => "Silahkan pilih",
                'buttonText' => 'select',
                'secret' => true,
                'lists' => [
                    [
                        'title' => '1. Petunjuk Penggunaan',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '2. Link Download',
                        //'description' => 'Formulir gratis',
                    ],
                ],
                //'footer' => 'Pilih layanan',
            ],
        ]
    ]
];
PostList($payload);
} elseif($message == "\xE2\xA4\xB5 <~ 7. Cetak Perincian Gaji#") {
  CekUsers('start#cetak_perincian_gaji');
  $pesan = "Silahkan isi data diri perincian gaji untuk di cetak:\n\n";
  $pesan .= "Nama :\n";
  $pesan .= "NRP/NIP :\n\n";
  $pesan .= "Silahkan salin dan isi pesan ini, paste dan kirim kembali untuk mem proses data anda.";
  echo $pesan;
  
  //echo "Silahkan salin pesan di atas, kirim kembali untuk mem proses data anda.";
} elseif($message == "\xE2\xA4\xB5 <~ 8. Informasi Lainnya#") {
  CekUsers('start#informasi_lainnya');
  $pesan = "Silahkan isi data diri untuk mengirim informasi lainnya:\n\n";
  $pesan .= "Nama :\n";
  $pesan .= "NRP/NIP :\n\n";
  $pesan .= "Silahkan salin dan isi pesan ini, paste dan kirim kembali dan admin akan menghubungi anda.";
  echo $pesan;
} elseif($message == "\xE2\xA4\xB5 <~ 9. Kontak Kami#") {
  CekUsers('start#kontak_kami');
  $data = [
      'phone' => $phone,
      'document' => $base_url . '/whatsapp_bot/document/kontak_kami.pdf',
      'secret' => true
  ];
PostDoc($data);
} elseif($message == "\xE2\xA4\xB5 <~ 10. Antrian Online#") {
  CekUsers('start#antrian_online#nama');
  echo "Silahkan input nama lengkap anda: ";
} elseif($message == "\xE2\xA4\xB5 <~ 11. Formulir Kepuasan Pelanggan#") {
  CekUsers('start#formulir_kepuasan_pelanggan');
  echo "Silahkan klik link di bawah ini\n\nhttps://forms.gle/iYBvTZscnVGRERvn9";
} else {
  if ($datanya['action'] == 'start#cetak_perincian_gaji' && substr($message, 0, 53) == 'Silahkan isi data diri perincian gaji untuk di cetak:') {
    $exp = explode(PHP_EOL, $message);
    $nama = $exp[2];
    $nrp = $exp[3];
    $exp_nama = explode(":", $nama);
    $exp_nrp = explode(":", $nrp);
    if(empty(trim($exp_nama[1])) || empty(trim($exp_nrp[1]))) {
      echo "Silahkan isi data.";
    } else {
      $pesan = "Terdapat Input perincian gaji users:<br><br>";
      $pesan .= trim($nama) . "<br>";
      $pesan .= trim($nrp) . "<br>";
      $pesan .= "Users Phone : " . $phone;
      if(PostAdmin($pesan)) {
        $txt = "Data perincian gaji berhasil dikirim, mohon tunggu kami akan meninjaunya dan segera mem proses data anda.";
        PostText($txt);
        CekUsers();
      }
    }
  //echo strlen('Silahkan isi data diri perincian gaji untuk di cetak:');
} elseif($datanya['action'] == 'start#informasi_lainnya' && substr($message, 0, 56) == 'Silahkan isi data diri untuk mengirim informasi lainnya:') {
  $exp = explode(PHP_EOL, $message);
  $nama = $exp[2];
  $nrp = $exp[3];
  $exp_nama = explode(":", $nama);
    $exp_nrp = explode(":", $nrp);
    if(empty(trim($exp_nama[1])) || empty(trim($exp_nrp[1]))) {
      echo "Silahkan isi data.";
    } else {
      $pesan = "Terdapat Input Informasi Lainnya users:<br><br>";
      $pesan .= trim($nama) . "<br>";
      $pesan .= trim($nrp) . "<br>";
      $pesan .= "Users Phone : " . $phone;
      if(PostAdmin($pesan)) {
        $txt = "Data informasi lainnya berhasil dikirim, mohon tunggu kami akan segera menghubungi anda sesaat lagi.";
        PostText($txt);
        CekUsers();
      }
    }
} elseif(substr($datanya['action'], 0, 25) == 'start#antrian_online#nama') {
  CekUsers('start#antrian_online#nrp#'.$message);
  echo "Silahkan input NRP/NIP: ";
} elseif(substr($datanya['action'], 0, 24) == 'start#antrian_online#nrp') {
  //CekUsers('start#antrian_online#nrp'.$message);
    
    $get = mysqli_query($con, "SELECT * FROM nomor_antrian");
    $cokot = mysqli_fetch_assoc($get);
    
    if($cokot['is_antri'] == '1') {
      echo 'Generate nomor antrian gagal! Bot sedang dalam antrian, silahkan tunggu beberapa menit dan coba kembali!';
    } else {
      mysqli_query($con, "UPDATE nomor_antrian SET is_antri = '1'");
      if($cokot['prefix'] == 'A') {
        mysqli_query($con, "UPDATE nomor_antrian SET prefix = 'B', nomor = nomor+1, is_antri = '0'");
        $d = "A".sprintf('%03d', $cokot['nomor']);
      }
      
      if($cokot['prefix'] == 'B') {
        mysqli_query($con, "UPDATE nomor_antrian SET prefix = 'A', nomor = nomor+1, is_antri = '0'");
        $d = "B".sprintf('%03d', $cokot['nomor']);
      }
      $exp = explode("#", $datanya['action']);
      $nama = trim($exp[3]);
      $nrp = $message;
      
      $filename1 = rand();
      $write1 = text_to_img('1',$rand=$d,$filename1,$data='');
      $write2 = text_to_img('2',$rand='',$write1,$data=$nama);
      $write3 = text_to_img('3',$rand='',$write2,$data=$nrp);
      $write4 = text_to_img('4',$rand='',$write3,$data='');
      $write5 = text_to_img('5',$rand='',$write4,$data='');
      $dataImg = [
        'phone' => $phone,
        'image' => $base_url . '/whatsapp_bot/upload/'.$filename1.'.png',
        'caption' => 'Silahkan simpan nomor antrian anda.',
      ];
      PostImg($dataImg);
      unlink('whatsapp_bot/upload/'.$filename1.'.png');
      CekUsers();
    }
} else {
CekUsers();
  $payload = [
    "data" => [
        [
            'phone' => $phone,
            'message'=> [
                'title' => "\xE2\xA4\xB5",
                'description' => "Hallo Sobat ASABRI! Selamat Siang.. Salam kenal ya, Aku IMAN (Information Mobile ASABRI Assistant) \xF0\x9F\x98\x8A \nAda Yang Bisa Iman Bantu?\n\nSIlahkan Pilih Kategori Yang Bapak / Ibu {$pushName} butuhkan :",
                'buttonText' => 'select',
                'secret' => true,
                'lists' => [
                    [
                        'title' => '1. Formulir Pelayanan',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '2. Formulir Pajak',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '3. Persyaratan',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '4. ASABRI MOBILE',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '5. ASABRI LINK',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '6. ASABRI STAR',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '7. Cetak Perincian Gaji',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '8. Informasi Lainnya',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                        'title' => '9. Kontak Kami',
                        //'description' => 'Formulir gratis',
                    ],
                    [
                     'title' => '10. Antrian Online'
                    
                    ],
                    [
                     'title' => '11. Formulir Kepuasan Pelanggan'
                    
                    ],
                ],
                //'footer' => 'Pilih layanan',
            ],
        ]
    ]
];
PostList($payload);
}
}
}